// ************************************************************************************************
//
// Zhler von 0 bis 9 mit Ausgabe an 7-Segment-Anzeige und Taster zum Einstellen des Wertes
// 
// PIC16F627A
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Methodenprototypen
uchar get7SegmentValue (uchar Wert, uchar DecimalPoint);

// ************************************************************************************************
// Hauptmethode
void main (void) {

	// ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen

	// PORTB als Ausgang definieren
	TRISB = 0;

	// Analogkomparator abschalten
	CMCON = 0b111;

	// RA0 als Tastereingang
	#define TASTER RA0

	// PORTB definieren
	#define DATEN PORTB

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// ****************************************************************************************
		// Variablen
		uchar Wert;

		// ****************************************************************************************
		// Wert verndern?
		if (TASTER) {
			Wert++;
			if (Wert == 10) {
				Wert = 0;
			}
			DATEN = get7SegmentValue(Wert, 0);
			while (TASTER);
		}

		// ****************************************************************************************
		// Wert ausgeben
		DATEN = get7SegmentValue(Wert, 0);

	}

}

// ************************************************************************************************
// wandelt einen Wert in ein Zeichen im 7-Segment-Code um
uchar get7SegmentValue (uchar Wert, uchar DecimalPoint) {

	// Variablen
	uchar result;

	// welches Ausgabemuster bei welchem Zeichen?
	//
	//   Bit    Segment
	//
	//    0       a
	//    1       b
	//    2       c
	//    3       d
	//    4       f
	//    5       g
	//    6       h
	//    7       DP
	//
	if (Wert == 0) {
		result = 0b00111111;
	} else if (Wert == 1) {
		result = 0b00000110;
	} else if (Wert == 2) {
		result = 0b01011011;
	} else if (Wert == 3) {
		result = 0b01001111;
	} else if (Wert == 4) {
		result = 0b01100110;
	} else if (Wert == 5) {
		result = 0b01101101;
	} else if (Wert == 6) {
		result = 0b01111101;
	} else if (Wert == 7) {
		result = 0b00000111;
	} else if (Wert == 8) {
		result = 0b01111111;
	} else if (Wert == 9) {
		result = 0b01101111;
	} else {
		result = 0b01110001;
	}

	// Dezimalpunkt aktiv?
	if (DecimalPoint) {
		result| = 0b10000000;
	}
	
	// Wert zurckgeben
	return (result);

}
